/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.client.gui.modmenu;

import de.ambertation.wunderlib.ui.layout.components.Checkbox;
import de.ambertation.wunderlib.ui.layout.components.HorizontalStack;
import de.ambertation.wunderlib.ui.layout.components.LayoutComponent;
import de.ambertation.wunderlib.ui.layout.components.Range;
import de.ambertation.wunderlib.ui.layout.components.VerticalStack;
import de.ambertation.wunderlib.ui.vanilla.LayoutScreenWithIcon;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.betterx.bclib.config.ConfigKeeper;
import org.betterx.bclib.config.Configs;
import org.betterx.bclib.config.NamedPathConfig;
import org.jetbrains.annotations.Nullable;

public class MainScreen
extends LayoutScreenWithIcon {
    static final ResourceLocation BCLIB_LOGO_LOCATION = new ResourceLocation("bclib", "icon.png");
    Map<Checkbox, Supplier<Boolean>> dependentWidgets = new HashMap<Checkbox, Supplier<Boolean>>();

    public MainScreen(@Nullable Screen parent) {
        super(parent, BCLIB_LOGO_LOCATION, (Component)Component.m_237115_((String)"title.bclib.modmenu.main"), 10, 10, 20);
    }

    protected <T> Component getComponent(NamedPathConfig config, NamedPathConfig.ConfigTokenDescription<T> option, String type) {
        return Component.m_237115_((String)(type + ".config." + config.configID + option.getPath()));
    }

    protected void updateEnabledState() {
        this.dependentWidgets.forEach((cb, supl) -> cb.setEnabled(((Boolean)supl.get()).booleanValue()));
    }

    protected <T> void addRow(VerticalStack grid, NamedPathConfig config, NamedPathConfig.ConfigTokenDescription<T> option) {
        if (ConfigKeeper.BooleanEntry.class.isAssignableFrom(option.token.type)) {
            this.addCheckbox(grid, config, option);
        } else if (ConfigKeeper.FloatEntry.class.isAssignableFrom(option.token.type)) {
            this.addFloat(grid, config, option);
        }
        grid.addSpacer(2);
    }

    protected void addFloat(VerticalStack grid, NamedPathConfig config, NamedPathConfig.ConfigTokenDescription<Float> option) {
        if (option.topPadding > 0) {
            grid.addSpacer(option.topPadding);
        }
        HorizontalStack row = grid.addRow();
        if (option.leftPadding > 0) {
            row.addSpacer(option.leftPadding);
        }
        Range cb = row.addRange(MainScreen.fixed((int)200), MainScreen.fit(), this.getComponent(config, option, "title"), (float)option.minRange, (float)option.maxRange, ((Float)config.getRaw(option.token)).floatValue()).onChange((caller, state) -> config.set(option.token, state.floatValue()));
    }

    protected void addCheckbox(VerticalStack grid, NamedPathConfig config, NamedPathConfig.ConfigTokenDescription<Boolean> option) {
        if (option.topPadding > 0) {
            grid.addSpacer(option.topPadding);
        }
        HorizontalStack row = grid.addRow();
        if (option.leftPadding > 0) {
            row.addSpacer(option.leftPadding);
        }
        Checkbox cb = row.addCheckbox(MainScreen.fit(), MainScreen.fit(), this.getComponent(config, option, "title"), ((Boolean)config.getRaw(option.token)).booleanValue()).onChange((caller, state) -> {
            config.set(option.token, state);
            this.updateEnabledState();
        });
        if (option.token instanceof NamedPathConfig.DependendConfigToken) {
            this.dependentWidgets.put(cb, () -> option.token.dependenciesTrue(config));
            cb.setEnabled(option.token.dependenciesTrue(config));
        }
    }

    public boolean m_6913_() {
        return false;
    }

    protected LayoutComponent initContent() {
        VerticalStack content = (VerticalStack)new VerticalStack(MainScreen.fit(), MainScreen.fit()).setDebugName("content");
        Configs.GENERATOR_CONFIG.getAllOptions().stream().filter(o -> o.hidden == false).forEach(o -> this.addRow(content, Configs.GENERATOR_CONFIG, (NamedPathConfig.ConfigTokenDescription)o));
        content.addSpacer(12);
        Configs.MAIN_CONFIG.getAllOptions().stream().filter(o -> o.hidden == false).forEach(o -> this.addRow(content, Configs.MAIN_CONFIG, (NamedPathConfig.ConfigTokenDescription)o));
        content.addSpacer(12);
        Configs.CLIENT_CONFIG.getAllOptions().stream().filter(o -> o.hidden == false).forEach(o -> this.addRow(content, Configs.CLIENT_CONFIG, (NamedPathConfig.ConfigTokenDescription)o));
        VerticalStack grid = (VerticalStack)new VerticalStack(MainScreen.fill(), MainScreen.fill()).setDebugName("main grid");
        grid.addScrollable((LayoutComponent)content);
        grid.addSpacer(8);
        grid.addButton(MainScreen.fit(), MainScreen.fit(), CommonComponents.f_130655_).onPress(button -> {
            Configs.CLIENT_CONFIG.saveChanges();
            Configs.GENERATOR_CONFIG.saveChanges();
            Configs.MAIN_CONFIG.saveChanges();
            this.m_7379_();
        }).alignRight();
        return grid;
    }
}

